/**
* \file: MediaAudioChannel.cpp
*
* \version: $Id:$
*
* \release: $Name:$
*
* Sample audio channel implementation for media playback
*
* \component: Baidu CarLife
*
* \author: P. Acar / ADIT/SW2 / pacar@de.adit-jv.com
*
* \copyright (c) 2017 Advanced Driver Information Technology.
* This code is developed by Advanced Driver Information Technology.
* Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
* All rights reserved.
*
* \see <related items>
*
* \history
*
***********************************************************************/

#include <string>
#include <adit_logging.h>
#include <bdcl/AilAudioSink.h>
#include "MediaAudioChannel.h"

LOG_IMPORT_CONTEXT(tbdcl)

// todo check return values of the calles methods

namespace adit { namespace bdcl {

// todo replace raw ptr with smart ptr
MediaAudioChannel::MediaAudioChannel(CoreCallbackDealer* inCallbackDealer)
{
    mAudioSink = new AilAudioSink(this, inCallbackDealer);

    /* set config items */
    mAudioSink->setConfigItem("audio-playback-device", "device=entertainment_main periodms=8 inittoutms=2000");
    mAudioSink->setConfigItem("audio-sink-stream-type", "AUDIO_STREAM_MEDIA");
    mAudioSink->setConfigItem("audio-sink-threshold-ms", "100");
    mAudioSink->setConfigItem("audio-sink-buffer-max-ms", "1000");
    mAudioSink->setConfigItem("disable-real-time-priority-audio", "0");
    mAudioSink->setConfigItem("audio-threads-real-time-priority", "61");
    mAudioSink->setConfigItem("audio-sink-channels", "2");
    mAudioSink->setConfigItem("audio-sink-bits-per-sample", "16");
    mAudioSink->setConfigItem("audio-sink-sampling-rate", "48000");
    mAudioSink->setConfigItem("audio-sink-record", "enable=0 filename=/tmp/audiosinkdump");

    mAudioSink->initialize();
}

MediaAudioChannel::~MediaAudioChannel()
{
    mAudioSink->teardown();
    delete mAudioSink;
}

void MediaAudioChannel::onPlaybackInit(unsigned int inSampleRate, unsigned int inChannelConfig, unsigned int inSampleFormat)
{
    mAudioSink->setConfigItem("audio-sink-sampling-rate", std::to_string(inSampleRate));
    mAudioSink->setConfigItem("audio-sink-channels", std::to_string(inChannelConfig));
    mAudioSink->setConfigItem("audio-sink-bits-per-sample", std::to_string(inSampleFormat));

    mAudioSink->initialize();

    mAudioSink->playbackStart();
}

void MediaAudioChannel::onPlaybackStop()
{
    mAudioSink->playbackStop(true);
}

void MediaAudioChannel::onPlaybackResume()
{
    mAudioSink->playbackStart();
}

void MediaAudioChannel::onPlaybackPause()
{
    mAudioSink->playbackStop(false);
}

void MediaAudioChannel::onError(bdclErrorCodes inErrorCode)
{
    LOG_ERROR((tbdcl, "Error: %d on Media audio channel", static_cast<uint32_t>(inErrorCode)));
}

} } /* namespace adit { namespace bdcl */
